function output = l1o_valid_svm4_PAR(input)
          
% [CM_aggr, CM, Acc_aggr, Acc, predict, model, prob, predict_sorted] 
% (inst, labels, subj_label, sc_low, sc_up, kernel, C, gamma, Pb, termination, maxlabelnum)

inst = input.inst;
labels = input.labels;
subj_label = input.subj_label; 
scalingtype = input.scalingtype;
sc_low = input.sc_low;
sc_up = input.sc_up;
kernel = input.kernel;
C = input.C;
gamma = input.gamma;
Pb = input.Pb;
termination = input.termination;
maxlabelnum = input.maxlabelnum;


%% Following leave-one-subject out validaiton approach:
% scaling, training, classification,
% confusion matrix evaluation.
% The result is saved and the algorithm continues until when all subjects are tested. 
[N,F] = size(inst);
ind = unique(subj_label);
Nsogg = length(ind);


% h = waitbar(0,'SVM: leave-1-out validation');
if (Nsogg == 1)
    disp(' --- Leave-1-out validation error: Nsogg must be at least 2 --- ')
    CM_aggr = [];
    CM = [];
    Acc_aggr = [];
    Acc = [];
    predict = [];predict_sorted = [];
else

    lab = unique(labels);
    CM = zeros(max(lab),max(lab),Nsogg);
    predict_sorted = zeros(size(labels));
    prob_sorted = zeros(size(labels,1), max(labels));
    
    
    %% Parallel LOSO    
    % Get default parallel cconfiguration ( which should enable core
    % parallelism)
    configName = defaultParallelConfig();
    
    % Initialize scheduler
    sched = findResource('scheduler', 'Configuration', configName);
    
    % Create a job
    job = createJob(sched);
    
    
    % CRUCIAL POINT: Put some taskw in a job
    % The syntax is as following:
    %             JOB  |  function handle (Task) |   n.output of myfun | args of my fun listen in a cell array
    % createTask( job   ,    @myfun              ,          1          ,             {pi/4} );
    % Intead of @myfun, put @ -- function name
%     t1 = createTask(job,@myfun,1,{-pi/4});
%     t2 = createTask(job,@myfun,1,{pi/4});
    % Creation of one task for each fold(subject)        
    for n = 1:Nsogg  
        %% assign TS e VS
        TS_inst_sc = [];
        VS_inst_sc = [];

        ne = []; lablist = [];
        
        VS_ind = (subj_label == ind(n));
        TS_ind = (subj_label ~= ind(n));

        TS_label = labels(TS_ind);
        TS_inst = inst(TS_ind,:);
        VS_label = labels(VS_ind);
        VS_inst = inst(VS_ind,:);
        
        %% normalization/standardization
        switch scalingtype
            case 1
                % scaling
                M = max(TS_inst);  %max e min of each feature
                m = min(TS_inst);
                for f = 1:F
                    TS_inst_sc(:,f) = ones(length(TS_inst(:,f)),1)*sc_low + (TS_inst(:,f)-ones(length(TS_inst(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
                    VS_inst_sc(:,f) = ones(length(VS_inst(:,f)),1)*sc_low + (VS_inst(:,f)-ones(length(VS_inst(:,f)),1)*m(f)) .* (sc_up-sc_low)/(M(f)-m(f));
                end
            case 2
                % scaling2 = (x-mean)/std
                me = mean(TS_inst);
                st = std(TS_inst);
                for f = 1:F
                    TS_inst_sc(:,f) = (TS_inst(:,f) - me(f)) ./ st(f);
                    VS_inst_sc(:,f) = (VS_inst(:,f) - me(f)) ./ st(f);
                end
        end
        input_fold{n}.TS_inst_sc = TS_inst_sc;
        input_fold{n}.VS_inst_sc = VS_inst_sc;
        input_fold{n}.TS_label = TS_label;
        input_fold{n}.VS_label = VS_label;
        input_fold{n}.kernel = kernel;
        input_fold{n}.C = C;
        input_fold{n}.gamma = gamma;
        input_fold{n}.Pb = Pb;
        input_fold{n}.termination = termination;

        auxiliary_fold{n}.TS_ind = TS_ind;
        auxiliary_fold{n}.VS_ind = VS_ind;
        
        tsk{n} = createTask(job,@myfun_SVM_TrTe_PAR,1,{input_fold{n}});      
    end
    
    
    % RUN job and all task in it
    submit(job);
    fprintf('Waiting for jobs...')
    % Wait here until job is finished
    
%     numTasksExecuted = 0;
%     set(job, 'UserData', numTasksExecuted);

    h = waitbar(0,'SVM: leave-1-out validation');
    states = cell(1,length(job.Tasks));
    while(strcmp(job.State,'running'))  
        
        %% conta task eseguiti
        % [pending running completed] = findTask(job);
        completed = findTask(job,'State','finished');
        waitbar(length(completed)/length(job.Tasks),h);
        
        pause(0.1)
%         
%         %% blocca tutto in caso di errore
%         for s = 1:length(completed)
%             if ~strcmp(job.Tasks(s).ErrorMessage,'')
%                 disp(['ERROR in TASK #' num2str(s) ', ==>(task function: ' func2str(job.Tasks(s).Function) '), ??? ' job.Tasks(s).ErrorMessage])
%                 disp('error stack:')
%                 St = length(job.Tasks(s).Error.stack);
%                 for st = 1:St
%                     disp(['function ' job.Tasks(s).Error.stack(st).name ', line ' num2str(job.Tasks(s).Error.stack(st).line) ])
%                 end
%                 
%                 destroy(job)
%                 close (h)
%                 error('==> Job destroyed')
%             end
%         end
    end
    %     waitForState(job, 'finished');
    fprintf('Finished!\n');    
    close (h);
    
%     FailedTasks = findTask(job,'State','failed')
%     CorrectTasksExecution = 1;
%     for s = 1:length(job.Tasks)
%         if ~strcmp(job.Tasks(s).ErrorMessage,'')
%             disp(['Task #' num2str(s) ', function: ' func2str(job.Tasks(s).Function) ])
%             disp(['    ERROR!: ' job.Tasks(s).ErrorMessage])
%             CorrectTasksExecution = 0;
%         end
%     end  
%     if ~CorrectTasksExecution 
%         error('Error in one or more tasks')
%     end
    
    % Get outputs of all the task (if any) in job
%     taskoutput1 = get(t1, 'OutputArguments');
%     taskoutput2 = get(t2, 'OutputArguments');
    taskoutput = getAllOutputArguments(job);
    for n = 1:Nsogg   
%         taskoutput = get(tsk{n}, 'OutputArguments');   
        
        predict{n} = taskoutput{n}.predict;
        prob_tmp{n} = taskoutput{n}.prob_tmp;
        accuracy(:,n) = taskoutput{n}.accuracy;
        model{n} = taskoutput{n}.model;
        VS_ind = auxiliary_fold{n}.VS_ind;
        TS_label = input_fold{n}.TS_label;
        VS_label = input_fold{n}.VS_label;
        
        lab1 = unique(VS_label);  
        lab3 = unique(TS_label);  %  stato aggiunto il 1ott2010
        lab2 = unique(predict{n});
        
        % confusion matrix
        [CM(lab1,lab2,n),ne,lablist] = confmat(input_fold{n}.VS_label, predict{n});
        
        if(Pb)
            % only in soft-assignment case
            [L U] = size(prob_tmp{n});
            prob{n}= zeros(L,maxlabelnum);
            prob{n}(:,lab3) = prob_tmp{n};            
            prob_sorted(VS_ind,:) = prob{n};
        else
            prob{n} = [];            
            prob_sorted = [];
        end
        predict_sorted(VS_ind) = predict{n};
        
    end 
%     
    
       
    
    %% Results aggregation    
    CM_aggr = sum(CM,3);
%     Acc_aggr = sum(accuracy(1,:))/Nsogg;
    Acc = accuracy(1,:);
%     prob = prob_sorted;

    Acc_aggr = trace(CM_aggr)/sum(sum(CM_aggr));

    % destroy job (here we loose all variables in the workspace of the job
    destroy(job);

    
end





%% SVM PARAMS (memo)
% options:
% -s svm_type : set type of SVM (default 0)
% 	0 -- C-SVC
% 	1 -- nu-SVC
% 	2 -- one-class SVM
% 	3 -- epsilon-SVR
% 	4 -- nu-SVR
% -t kernel_type : set type of kernel function (default 2)
% 	0 -- linear: u'*v
% 	1 -- polynomial: (gamma*u'*v + coef0)^degree
% 	2 -- radial basis function: exp(-gamma*|u-v|^2)
% 	3 -- sigmoid: tanh(gamma*u'*v + coef0)
% -d degree : set degree in kernel function (default 3)
% -g gamma : set gamma in kernel function (default 1/num_features)
% -r coef0 : set coef0 in kernel function (default 0)
% -c cost : set the parameter C of C-SVC, epsilon-SVR, and nu-SVR (default 1)
% -n nu : set the parameter nu of nu-SVC, one-class SVM, and nu-SVR (default 0.5)
% -p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)
% -m cachesize : set cache memory size in MB (default 100)
% -e epsilon : set tolerance of termination criterion (default 0.001)
% -h shrinking: whether to use the shrinking heuristics, 0 or 1 (default 1)
% -b probability_estimates: whether to train a SVC or SVR model for probability estimates, 0 or 1 (default 0)
% -wi weight: set the parameter C of class i to weight*C, for C-SVC (default 1)
% 
% The k in the -g option means the number of attributes in the input data.
% To install this tool, please read the README file in the package. There are Windows, X, and Java versions in the package.

%%
% [CM_aggr, CM, Acc_aggr, Acc, predict, model, prob, predict_sorted] 
output.CM_aggr = CM_aggr;
output.CM = CM;
output.Acc_aggr = Acc_aggr;
output.Acc = Acc;
output.predict = predict;
output.model = model;
output.prob = prob;
output.predict_sorted = predict_sorted;
output.prob_sorted = prob_sorted;


